from rubpy.bot.models import Keypad,KeypadRow,Button,ButtonTypeEnum,ChatKeypadTypeEnum,ButtonLink,JoinChannelData,OpenChatData
from rubpy.bot.enums import ButtonLinkTypeEnum

default_keyboard = Keypad([
    KeypadRow([
        Button("1",ButtonTypeEnum.SIMPLE,"➕ اضافه کردن به گروه")
    ]),
    KeypadRow([
        Button("3",ButtonTypeEnum.SIMPLE,"👤 حساب کاربری"),
        Button("2",ButtonTypeEnum.SIMPLE,"📚 راهنما")
    ]),
    KeypadRow([
        Button("4",ButtonTypeEnum.SIMPLE,"📞  ارتباط با پشتیبانی")
    ])
],True)

panel_keyboard = Keypad([
    KeypadRow([
        Button("send_all",ButtonTypeEnum.SIMPLE,"📤 ارسال همگانی"),
        Button("static",ButtonTypeEnum.SIMPLE,"📊 امار کلی")
    ]),
    KeypadRow([
        Button("unban_member",ButtonTypeEnum.SIMPLE,"✅ رفع مسدودیت"),
        Button("ban_member",ButtonTypeEnum.SIMPLE,"🚫 مسدودیت کاربر")
    ]),
    KeypadRow([
        Button("must_join",ButtonTypeEnum.SIMPLE,"📢 جوین اجباری")
    ]),
    KeypadRow([
        Button("exit",ButtonTypeEnum.SIMPLE,"⬅️ خروج از پنل")
    ])
],resize_keyboard=True)

back_keyboard = Keypad([
    KeypadRow([
        Button("back",ButtonTypeEnum.SIMPLE,"بازگشت ⬅️")
    ])
],resize_keyboard=True)

backhelp = Keypad([
    KeypadRow([
        Button(
            "back_help",
            ButtonTypeEnum.SIMPLE,
            "برگشت"
        )
    ])
])

inlines_help = Keypad([
    KeypadRow([
        Button(
            "game_help",
            ButtonTypeEnum.SIMPLE,
            "لیست بازی"
        )
    ]),
    KeypadRow([
        Button(
            "hobbies_help",
            ButtonTypeEnum.SIMPLE,
            "لیست سرگرمی"
        )
    ])
])

actions = {
    "⬅️ خروج از پنل":{
        "text":"شما از پنل خارج شدید",
        "keyboard":default_keyboard,
        "type":ChatKeypadTypeEnum.NEW
    },
    "➕ اضافه کردن به گروه":{
        "text":"""
برای افزودن ربات به گروه، مراحل زیر را دنبال کنید:

1. روی «افزودن عضو» کلیک کنید.
2. آیدی ربات را بدون @ در قسمت جستجوی افراد وارد کنید.
3. روی «تایید» بزنید تا ربات به گروه اضافه شود.

⚠️ توجه:
ربات باید در گروه حتماً ادمین باشد تا بتواند شروع به فعالیت کند.
""",
        "keyboard":None,
        "type":ChatKeypadTypeEnum.NONE
    },
    "📚 راهنما":{
        "text":"""
به ربات آرکابات خوش آمدید!😍❤️

برای چت با ربات و استفاده از امکانات:

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.


🤖 برای گفتگو با هوش مصنوعی، فقط کافیست در ابتدای سوال خود از /ai استفاده کنید.

🖼️ برای ساخت تصویر، کافیه ابتدای متن خود /image را قرار دهید.

از همراهی شما خوشحالیم! 💬📸""",
    "keyboard":None,
    "type":ChatKeypadTypeEnum.NONE
    }
}