# Main Framework
from rubpy.bot import BotClient
from rubpy.bot.models import Update,InlineMessage
from rubpy.bot import filters
from rubpy.bot.models import ChatKeypadTypeEnum
from typing import Union

# Modules 
import keyboards
import assets

# ORM Databases
from ormax import Database,Model
from ormax.exceptions import DoesNotExist,ValidationError
from ormax.fields import CharField,BooleanField,IntegerField,TextField,BinaryField


# Utills 
from random import randint
from time import time
import aiofiles
from urllib.parse import quote
import os
import datetime
from jdatetime import datetime as jdatetime
import asyncio
import aiohttp
import orjson


# Enviroments Variabes
bot = BotClient("CCEJH0DXTHUYXOCZTEHPUJJTDUHEAFPSBKISJRJVXSDCARWAEIBVWVFOZBWOHWJZ")

# DB Enviroments
class GroupData(Model):
    # Name
    chat_id = CharField(50,primary_key=True)
    name = CharField()
    voice = CharField(100)
    image = CharField(100)
    speak_file = CharField(100)
    users = BinaryField()
    creator_id = CharField(50, nullable=True)

    # Check False Or True
    remove_link = BooleanField()
    ai = BooleanField()
    wrong = BooleanField()
    speak = BooleanField()
    low_talk = BooleanField()
    status = BooleanField()

class UserData(Model):
    chat_id = CharField(50)
    user_id = CharField(50)
    id = IntegerField(primary_key=True)
    startdate = CharField(50)
    isadmin = BooleanField()
    level = IntegerField()

async def handle_apis(text, update: Update):
    for key, method_name in assets.KEY_TO_METHOD.items():
        if text == key:
            async with aiohttp.ClientSession() as session:
                async with session.get("https://arkabat.ir/web/"+method_name+".php") as res:
                    await update.reply(
                        await res.text()
                    )
                    return True

    if "چالش" in text:
        await update.reply(assets.challenges[randint(1,len(assets.challenges)-1)])
        return True
    return False

async def generateAnswer(prompt:str,update: Update):
    async with aiohttp.ClientSession() as session:
        async with session.get("https://arkabat.ir/ai/ChatGPT.php",params={
            "guid":update.chat_id,
            "text":prompt
        }) as res:
            await update.reply(
                (await res.json())["response"])

def detectLink(text: str):
    badthings = [
        "https://",
        "http://",
        ".ir",
        ".com",
        ".net",
        ".org",
        ".ai",
        "www."
    ]
    for thing in badthings:
        if thing in text:
            return True
    return False

async def generateImage(prompt:str,update: Update):
    print("Generating Image")
    # First Translate
    async with aiohttp.ClientSession(timeout=aiohttp.ClientTimeout(10)) as session:
        async with session.get("https://arkabat.ir/translation.php?text="+str(prompt)) as res:
            prompt_en = await res.text()
    
    # So Go Generating
    statusMSG = (await update.reply("لطفا صبر کنید.")).message_id
    print("Generating...")
    async with aiohttp.ClientSession(timeout=aiohttp.ClientTimeout(30)) as session:
        async with session.get("https://arkabat.ir/ai/BotAi.php",params={
            "translation":prompt_en,
            "text":quote(prompt),
            "type":"none",
            "prompt":"none"
        }) as res:
            imageData = orjson.loads( (await res.text()).encode() )
    print("ERROR: ",imageData)
    
    # And DownloadIng 
    if(imageData.get("created_at") == None):
        return None
    
    imagepath = str(int(time()))+update.chat_id+".jpg"
    print("Downloading...")
    async with aiofiles.open(imagepath,"wb") as fp:
        async with aiohttp.ClientSession() as session:
            async with session.get("https://arkabat.ir/ai/test.php?image="+imageData.get("image_path")) as res:
                await fp.write(await res.content.read())
    
    # And Next Send Image
    try:
        await bot.send_file(update.chat_id,imagepath,type="Image",reply_to_message_id=update.new_message.message_id)
    except Exception as e:
        print(e)
    
    os.remove(imagepath)
    await bot.delete_message(update.chat_id,statusMSG)
    print("End Generating")

async def generateVoice(prompt:str, update: Update, speaker:str):
    print("Generating...")
    voicePath = str(int(time()))+update.chat_id+".wav"
    async with aiohttp.ClientSession(timeout=aiohttp.ClientTimeout(15)) as session:
        async with session.get("https://arkabat.ir/ai/voice.php?speaker="+speaker+"&text="+quote(prompt)) as res:
            async with aiofiles.open(voicePath,"wb") as fp:
                await fp.write(await res.content.read())

    print("Sending")
    await update.reply_voice(voicePath)


# ORM Functions
async def track_group(chat_id:str, sender_id: str):
    print("Group Tracked")
    try:
        group = (await GroupData.objects().get(chat_id=chat_id))
    except DoesNotExist as e:
        print("Isn't Existed So: ",e)
        group = await GroupData.create(
            name="گروه",
            chat_id=chat_id,
            voice="shahriyar",
            image="none",
            users=orjson.dumps([
                {
                    "sender_id":sender_id,
                    "messages":1
                }
            ]),
            slience=b"[]",
            speak_file="good_speak.json",
            remove_link=True,
            ai=True,
            wrong=True,
            speak=True,
            low_talk=True,
            status=True
        )

    users = orjson.loads(group.users)
    
    user = {}
    for iuser in users:
        if iuser["sender_id"] == sender_id:
            user = iuser
            break

    if user == {}:
        users.append({
            "sender_id":sender_id,
            "messages":1,
            "nickname":"لقب تعیین نشده",
            "org":"اصل تعیین نشده"
        })
        user = {
            "sender_id":sender_id,
            "messages":1,
            "nickname":"لقب تعیین نشده",
            "org":"اصل تعیین نشده"
        }
        group.users = orjson.dumps(users)
        await group.save()
    
    return group,user

async def track_user(chat_id:str,user_id:str):
    try:
        user = (await UserData.objects().get(chat_id=chat_id))
    except DoesNotExist:
        while True:
            print("Retry Creating")
            try:
                user = await UserData.create(
                    id=randint(100000000, 999999999),
                    chat_id=chat_id,
                    user_id=user_id,
                    level=0,
                    isadmin=False,
                    startdate=datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                )
            except Exception as e:
                print("ERROR: DB: ",e)
                continue
            break
    return user



# Initing Works
db = Database("sqlite:///db_arka.db")
db.register_model(GroupData)
db.register_model(UserData)

async def main():
    await db.connect()
    await db.create_tables()

    # Group Management
    @bot.on_update(filters.update_type("UpdatedMessage"))
    async def handle_updated_message(client: BotClient, update:Update):
       # Checking Filtering
        if detectLink(update.updated_message.text):
            await client.delete_message(update.chat_id, update.updated_message.message_id)

    @bot.on_update(filters.group, filters.commands("start"))
    async def start_group(client: BotClient,update: Update):
        group, user = await track_group(update.chat_id,update.new_message.sender_id)
        
        await update.reply("""
به ربات آرکابات خوش آمدید!😍❤️

برای چت با ربات و استفاده از امکانات:

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.

از همراهی شما خوشحالیم! 💬📸
""")

    @bot.on_update(filters.group, filters.text)
    async def find_anwser(client: BotClient,update: Update):
        group,user = await track_group(update.chat_id,update.new_message.sender_id)
        text = update.new_message.text.replace(assets.botid,"").replace("/","")
        
        # Checking Filtering
        if detectLink(text):
            await client.delete_message(update.chat_id, update.new_message.message_id)


        if text.startswith("ai") or text.startswith("+"):
            if text.startswith("ai"):
                startfrom = 2
            elif text.startswith("+"):
                startfrom = 1
            await generateAnswer(text[startfrom:],update)
        
        elif text.startswith("ویس"):
            await generateVoice(text[3:],update,group.voice)
            return None
        
        elif text.startswith("تصویر") or text.startswith("تصویر") or text.startswith("image"):
            await generateImage(text[5:],update)
            return None
        
        elif text.startswith("لیست سرگرمی") or text.startswith("سرگرمی"):
            await update.reply("""
◄  سرگرمی 〔 🎯  〕

⟡  جوک
⟡  بیو
⟡  فال
⟡  فکت
⟡  دقت
⟡  شعر
⟡  پ ن پ
⟡  مورد
⟡  ساعت 
⟡  حدیث
⟡  تکست
⟡  ساعت
⟡  تاریخ
⟡  بعضیا
⟡  اعتراف
⟡  خاطره
⟡  فانتزی
⟡  داستان
⟡  تخریب
⟡  دانستنی
⟡  انگیزشی
⟡  یه وقت
""")
        
        elif text.startswith("لیست بازی") or text.startswith("بازی"):
            await update.reply("""
◄  بازی 〔 🎲 〕

⟡  چالش
⟡  تاس
⟡  سکه 
⟡  کویز
""")
        # Quiz
        elif text == "کویز":
            async with aiohttp.ClientSession() as session:
                async with session.get("https://arkabat.ir/web/quiz.php") as res:
                    result = await res.json()
                    await client.send_poll(update.chat_id,result["text"],result["list"])
        
        elif text == "تاس":
            await update.reply(
                assets.tas_list[randint(0,5)]
            )
        
        elif text == "سکه":
            await update.reply(
                ["خط","شیر"][randint(0,1)]
            )        
        
        elif await handle_apis(text,update):
            pass
        
        else:
            # Check Handling Answers?
            answer = assets.get_answer(text)
            if answer == False:
                answer = assets.get_answer(text.replace(" ",""))
                if answer == False:
                    return None

            # Parsing Answer 
            resultAnswer = answer.replace("#نام","").replace("#اسم","").replace("#لینک","").replace("#هایپر","").replace("#گروه","")
            if "#ساعت" in resultAnswer:
                resultAnswer = resultAnswer.replace("#ساعت",str(jdatetime.now().strftime("%H:%M:%S")))
            elif "#تاریخ" in resultAnswer:
                resultAnswer = resultAnswer.replace("#تاریخ",str(jdatetime.now().strftime("%Y/%m/%d")))
            
            await update.reply(resultAnswer.replace("mlm"," "))
    
    # PV: Handlers
    @bot.on_update(filters.private,filters.text("ارسال همگانی ✉️"))
    async def handle_sendAll(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        user =  users.get_row_by_colum("chat_id",update.chat_id)
        await update.reply("لطفا متن مورد نظر بفرستید.",keyboards.back_keyboard,chat_keypad_type=ChatKeypadTypeEnum.NEW)
        # Need Work
    
    @bot.on_update(filters.private,filters.text("بازگشت ⬅️"))
    async def handle_back(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)

        user =  users.get_row_by_colum("chat_id",update.chat_id)
        await update.reply("به صفحه اصلی برگشتی",keyboards.default_keyboard,chat_keypad_type=ChatKeypadTypeEnum.NEW)
        users.body[users.body.index(user)]["level"] = 0
    
    @bot.on_update(filters.private,filters.text("📞  ارتباط با پشتیبانی"))
    async def send_guid(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        
        print("Contact: BOT")
        await handle_private(client,update)
        await update.reply("برای ارتباط با پشتیبانی به ایدی زیر پیام دهید: \n\n@iddotir")
    
    @bot.on_update(filters.private,filters.text("امار کلی 📊"))
    async def handle_back(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        
        # Need Work
        await update.reply(f"""
📊| امار ربات

👤| کاربران: {str(len(users.body))}
👥| گروه ها: {str(len(groups.body))}
""")

    @bot.on_update(filters.private,filters.text("👤 حساب کاربری"))
    async def handle_info(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        
        user = users.get_row_by_colum("chat_id",update.chat_id)
        await update.reply(f"""
👤 حساب کاربری

🆔 آیدی کاربر: {user["userID"]}
📅 تاریخ عضویت: {user["startdate"]}
""")

    @bot.on_update(filters.private,filters.update_type("InlineMessage"))
    async def handle_inlines(client:BotClient,update: Union[InlineMessage,Update]):
        if update.get("aux_data") == None:
            return
        data = update.get("aux_data").get("button_id")
        if(data == "game_help"):
            await bot.edit_message_text(update.chat_id,update.message_id,"""
🎮 برای دریافت لیست بازی!

• لیست بازی را گروه ارسال کنید.

» فراموش نکنید!

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.

⚠️ در صورتی که از طریق روش های بالا  پیام بفرستید برای ربات قابل پردازش است.
""")
            await bot.edit_message_keypad(update.chat_id,update.id,keyboards.backhelp)
        elif(data == "hobbies_help"):
            await bot.edit_message_text(update.chat_id,update.message_id,"""
🎯 برای دریافت لیست سرگرمی!

• لیست سرگرمی را گروه ارسال کنید.

» فراموش نکنید!

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.

⚠️ در صورتی که از طریق روش های بالا پیام بفرستید برای ربات قابل پردازش است.
""")
            await bot.edit_message_keypad(update.chat_id,update.id,keyboards.backhelp)
        elif(data == "back_help"):
            await bot.edit_message_text(update.chat_id,update.message_id,"""
به ربات آرکابات خوش آمدید!😍❤️

برای چت با ربات و استفاده از امکانات:

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.


🤖 برای گفتگو با هوش مصنوعی، فقط کافیست در ابتدای سوال خود از /ai استفاده کنید.

🖼️ برای ساخت تصویر، کافیه ابتدای متن خود /image را قرار دهید.

از همراهی شما خوشحالیم! 💬📸
""")
        await bot.edit_message_keypad(update.chat_id,update.id,keyboards.inlines_help)

    @bot.on_update(filters.private,filters.text("📚 راهنما"))
    async def send_help(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        
        await update.reply("""
به ربات آرکابات خوش آمدید!😍❤️

برای چت با ربات و استفاده از امکانات:

• ربات را در پیام خود منشن کنید.
• یا روی پیام ربات ریپلای کنید.
• یا ابتدای متن خودتان / قرار دهید.


🤖 برای گفتگو با هوش مصنوعی، فقط کافیست در ابتدای سوال خود از /ai استفاده کنید.

🖼️ برای ساخت تصویر، کافیه ابتدای متن خود /image را قرار دهید.

از همراهی شما خوشحالیم! 💬📸""",inline_keypad=keyboards.inlines_help)


    @bot.on_update(filters.private, filters.commands("start"))
    async def start_private(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        await bot.send_message(update.chat_id,"""
به ربات آرکابات خوش آمدید! 👋

برای شروع می‌توانید از دکمه‌های زیر استفاده کنید:
""",chat_keypad=keyboards.default_keyboard,chat_keypad_type=ChatKeypadTypeEnum.NEW)
    
    @bot.on_update(filters.private,filters.commands("panel_1404_X_arka_plus_bb_bot"))
    async def open_panel(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)        
        await update.reply("به پنل مدیریت خوش امدید.",chat_keypad=keyboards.panel_keyboard,chat_keypad_type=ChatKeypadTypeEnum.NEW)

    @bot.on_update(filters.private,filters.text)
    async def handling_keyboards(client: BotClient,update: Update):
        user = await track_user(update.chat_id,update.new_message.sender_id)
        
        for key in keyboards.actions.keys():
            if key == update.new_message.text:
                if not keyboards.actions[key].get("inline") == None:
                    await update.reply(keyboards.actions[key]["text"],inline_keypad=keyboards.actions[key]["keyboard"])
                else:
                    await update.reply(keyboards.actions[key]["text"],keyboards.actions[key]["keyboard"],chat_keypad_type=keyboards.actions[key]["type"])
                return None

    print("Start Bot")
    #await bot.run()
    await bot.run("https://www.botarka.f5f102.site/arka1bot/hook.php?type=group","/","127.0.0.1",8089)
    
asyncio.run(main())