# Put Assets And Strings Here

import orjson
from random import randint

tas_list = [
    "⬤",
    "⬤ ⬤",
    "  ‌⬤\n⬤ ⬤",
    "⬤ ⬤\n⬤ ⬤",
    "⬤ ⬤\n  ⬤\n⬤ ⬤",
    "⬤ ⬤\n⬤ ⬤\n⬤ ⬤",
]

with open("good_speak.json","rb") as fp:
    speach = orjson.loads(fp.read())

with open("challenge.json","rb") as fp:
    challenges = orjson.loads(fp.read())

botid = "@ArKa1_BoT"

KEY_TO_METHOD = {
    "جوک": "jok",
    "پانپ": "panap",
    "پ ن پ": "panap",
    "تکست": "text",
    "خاطره": "khaterh",
    "اعتراف": "eteraf",
    "دقت": "daght",
    "بعضیا": "bazia",
    "وقت": "vaght",
    "فانتزی": "fantzi",
    "تخریب": "takharib",
    "انگیزشی": "engizeshi",
    "دانستنی": "danstani",
    "فکت": "fackt",
    "مورد": "moord",
    "بیو": "bio",
    "داستان": "dastan",
    "فال": "fal",
    "شعر": "sher",
    "حدیث": "hadis"
}

# Check it's not fixed
def get_answer_fixed(text:str):
    for answer in speach["equal"]:
        if answer["text"] == text:
            return answer["request"]
    return False

def get_answer_contain(text:str):
    for answer in speach["contain"]:
        if answer["text"] in text:
            return answer["request"]
    return False

def get_answer_random(text:str):
    for answer in speach["random"]:
        if text in answer:
            return answer[text][randint(0,len(answer[text])-1)]
    return False

def get_answer_contain_random(text:str):
    for answer in speach["randome"]:
        if answer["text"] in text:
            return answer[answer["text"]][randint(0,len(answer[answer["text"]])-1)]
    return False

def get_answer(text:str):
    answer = get_answer_fixed(text)
    if answer == False:
        answer = get_answer_random(text)
        if answer == False:
            answer = get_answer_contain(text)
            if answer == False:
                return get_answer_contain_random(text)
    return answer
